<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Calender;
use RealRashid\SweetAlert\Facades\Alert;
use Exception;

class CalenderController extends Controller
{
    public function index()
    {
        $calenders = Calender::latest()->get();
        $title = 'Delete Session!';
        $text = "Are you sure you want to delete?";
        confirmDelete($title, $text);
        return view("admin.calender", ["calenders" => $calenders]);
    }

    public function store(Request $request)
    {
        $request->validate([
            'sess' => 'required',
            'term' => 'required',
            'att' => 'required'
        ]);

        try {
            Calender::create([
                'session' => $request->sess,
                'term' => $request->term,
                'att' => $request->att
            ]);

            Alert::success("Added Successfully", "Session and Term added Successfully");
            return redirect()->back();
        } catch (Exception $e) {
            Alert::toast("Operation Failed" . $e->getMessage(), 'error');
            return redirect()->back();
        }
    }

    public function delete($id){
        Calender::where('id', $id)->delete();
        Alert::success('Deleted Successfully', "Record deleted successfully");
        return redirect()->back();
    }
}
