<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use App\Models\QuestionBank;
use App\Models\Subject;
use App\Models\Subtable;
use App\Models\Calender;
use RealRashid\SweetAlert\Facades\Alert;

class CbtController extends Controller
{
    public function index()
    {
        $teacher = Subject::where('id', Auth::id())->first();
        $subjects = Subtable::where('teacher_id', $teacher->teacher_id)->get();
        $current = Calender::latest()->first();
        $term = $current->term;
        $session = $current->session;

        return view("cbt-upload.index", ["teacher" => $teacher, "subjects" => $subjects, "term" => $term, "session" => $session]);
    }

    public function query(Request $request)
    {
        $request->validate([
            'class' => 'required',
            'subject' => 'required'
        ]);

        $data = [
            'class' => $request->class,
            'session' => $request->sess,
            'term' => $request->term,
            'subject' => $request->subject
        ];

        $questions = QuestionBank::where([
            'class' => $data['class'],
            'term' => $data['term'],
            'subject' => $data['subject']
        ])->latest()->get();

        $title = 'Delete Question!';
        $text = "Are you sure you want to delete?";
        confirmDelete($title, $text);
        return view('cbt-upload.questionbank', ['data' => $data, 'questions' => $questions]);
    }

    public function addQuestion(Request $request)
    {
        $request->validate([
            'question' => 'required',
            'option1' => "required",
            'option2' => "required",
            'option3' => "required",
            'option4' => "required",
            'correct_option' => "required",
            'class' => 'required',
            'term' => 'required',
            'subject' => 'required',
            'topic' => 'required'
        ]);

        try {
            QuestionBank::create([
                'question' => $request->question,
                'option1' => $request->option1,
                'option2' => $request->option2,
                'option3' => $request->option3,
                'option4' => $request->option4,
                'correct_option' => $request->correct_option,
                'class' => $request->class,
                'term' => $request->term,
                'subject' => $request->subject,
                'topic' => $request->topic,
            ]);

            Alert::toast('Question Added Successfully', 'success');
            return redirect()->back();
        } catch (\Exception $e) {
            Alert::toast("Operation Failed" . $e->getMessage(), 'error');
            return redirect()->back();
        }
    }

    public function delete($id)
    {
        QuestionBank::where('id', $id)->delete();
        Alert::toast("Question deleted successfully", 'success');
        return redirect()->back();
    }

    public function createCBTExam(){}

    public function storeCBTExam(){}

}
