<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSubtablesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('subtables', function (Blueprint $table) {
            $table->id();
            $table->string('teacher_id');
            $table->string('subject');
            $table->set('level', ['SSS', 'JSS', 'Primary']);
            $table->set('department', ['Science', 'Commercial', 'Art'])->nullable();
            $table->longText('schedule')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('subtables');
    }
}
