<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('subject_registrations', function (Blueprint $table) {
            $table->id();
            $table->string('reg_no');
            $table->foreign('reg_no')->references("reg_no")->on('students');
            $table->string('term')->nullable();
            $table->string('session')->nullable();
            $table->longText('subjects')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('subject_registrations');
    }
};
