<x-guest-layout>
    <!-- Session Status -->
    <x-auth-session-status class="mb-4" :status="session('status')" />

    <form method="POST" action="{{ route('login') }}">
        @csrf

        <!-- Email Address -->
        <div>
            <x-input-label for="teacher_id" :value="__('ID')" />
            <x-text-input id="teacher_id" class="block mt-1 w-full" type="text" name="teacher_id" :value="old('teacher_id')"
                required autofocus autocomplete="username" />
            <x-input-error :messages="$errors->get('teacher_id')" class="mt-2" />
        </div>

        <!-- Password -->
        <div class="mt-4">
            <x-input-label for="password" :value="__('Password')" />

            <x-text-input id="password" class="block mt-1 w-full" type="password" name="password" required
                autocomplete="current-password" />

            <x-input-error :messages="$errors->get('password')" class="mt-2" />
        </div>

        <!-- Remember Me -->
        <div class="block mt-4">
            <div>
                <input type="checkbox" id="toggleVisibility" />
                <label for="toggleVisibility">Show Password</label>
            </div>
        </div>
        <script>
            // 1. Get the elements
            const passwordInput = document.getElementById("password");
            const toggleVisibility = document.getElementById("toggleVisibility");

            // 2. Add an event listener to the checkbox
            toggleVisibility.addEventListener('change', function() {
                // 3. Check if the checkbox is checked
                if (this.checked) {
                    // Change type to "text" to show password
                    passwordInput.type = "text";
                } else {
                    // Change type back to "password" to hide password
                    passwordInput.type = "password";
                }
            });
        </script>

        <div class="flex items-center justify-end mt-4">
            @if (Route::has('password.request'))
                <a class="underline text-sm text-gray-600 hover:text-gray-900 rounded-md focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500"
                    href="{{ route('password.request') }}">
                    {{ __('Forgot your password?') }}
                </a>
            @endif

            <x-primary-button class="ms-3">
                {{ __('Log in') }}
            </x-primary-button>
        </div>
    </form>
</x-guest-layout>
