<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <title><?php echo e($payment->reg_no); ?> <?php echo e($payment->term); ?> <?php echo e($payment->session); ?> Receipt</title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

        <!-- Scripts -->
        <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    </head>
    <script type="text/javascript">
        setTimeout(() => { window.addEventListener("load", window.print()); }, 5000);

    </script>
    <body class="font-sans antialiased">
        <?php echo $__env->make('sweetalert::alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <?php
            $surname = DB::table("students")->where("id", Auth::id())->first()->surname;
            $firstname = DB::table("students")->where("id", Auth::id())->first()->firstname;
            $reg_no = DB::table("students")->where("id", Auth::id())->first()->reg_no;

            //date in mm/dd/yyyy format; or it can be in other formats as well
            $birthDate = DB::table('students')
                        ->where('reg_no', $reg_no)->first()->DoB;
            //explode the date to get month, day and year
            if ($birthDate != null){
            $birthDate = explode("-", $birthDate);
            //get age from date or birthdate
            $age = (date("md", date("U", mktime(0, 0, 0, $birthDate[2], $birthDate[1], $birthDate[0]))) > date("md")
            ? ((date("Y") - $birthDate[0]) - 1)
            : (date("Y") - $birthDate[0]));
            } else {
            $age = " ";
            }
        ?>

        <div class="flex justify-center mt-8">
            <div class="w-full mt-12 py-2 px-4 text-xl">
                <div class="flex my-4">
                    <div class="w-full flex justify-between">
                        <div>
                            <?php if (isset($component)) { $__componentOriginal8892e718f3d0d7a916180885c6f012e7 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.application-logo','data' => ['class' => 'w-30 h-20 fill-current text-gray-500']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('application-logo'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-30 h-20 fill-current text-gray-500']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8892e718f3d0d7a916180885c6f012e7)): ?>
<?php $component = $__componentOriginal8892e718f3d0d7a916180885c6f012e7; ?>
<?php unset($__componentOriginal8892e718f3d0d7a916180885c6f012e7); ?>
<?php endif; ?>
                        </div>
                        <div>
                            <h2 class="text-xl font-bold">
                                OAKFIELD SCHOOLS
                            </h2>
                            <h4 class="text-sm italic">Nursery, Primary and Secondary</h4>
                            <h4 class="text-sm ">ORIMERUNMU ROAD, ORIMERUNMU, OGUN STATE</h4>
                            <h4 class="text-sm italic">The Preferred....</h4>
                        </div>
                    </div>
                </div>
                <div class="text-black text-center w-full my-2 py-2 px-4">
                    <h3 class="text-xl font-extrabold"><?php echo e($payment->session); ?>, <?php echo e($payment->term); ?> Receipt</h3>
                    <table class="w-full text-left border-collapse border border-slate-500 text-sm">
                        <thead>
                        <tr class="py-2 px-4 font-semibold">
                            <th class="border border-slate-500" colspan="2">Name: <?php echo e($surname); ?> <?php echo e($firstname); ?></th>
                            <th class="border border-slate-500">Reg_no: <?php echo e($reg_no); ?></th>
                            <th class="border border-slate-500">Receipt ID: <?php echo e($receipt->receiptID); ?></th>
                        </tr>
                        <tr class="py-2 px-4 font-semibold">
                            <th class="border border-slate-500">Class: <?php echo e($payment->class); ?></th>
                            <th class="border border-slate-500">Payment Method: <?php echo e($transaction->details); ?></th>
                            <th class="border border-slate-500">Term: <?php echo e($payment->term); ?></th>
                            <th class="border border-slate-500">Session: <?php echo e($payment->session); ?></th>
                        </tr>
                        </thead>
                    </table>
                    <table class="w-full my-4 text-left border-collapse border border-slate-500">
                        <thead>
                            <tr class="py-2 px-4 font-semibold text-sm">
                                <th class="border border-slate-500">Description</th>
                                <th class="border border-slate-500"><?php echo e(strtoupper($payment->type)); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr class="py-2 px-4 text-sm">
                                <td class="border border-slate-500">Amount Paid</td>
                                <td class="border border-slate-500 text-green-700"><?php echo e($transaction->amount); ?></td>
                            </tr>

                            <tr class="py-2 px-4 text-sm">
                                <td class="border border-slate-500">Balance</td>
                                <td class="border border-slate-500 text-red-600"><?php echo e($payment->payableamount - $payment->amountpaid); ?></td>
                            </tr>

                            <tr class="py-2 px-4 text-sm">
                                <td class="border border-slate-500">Total Amount Paid</td>
                                <td class="border border-slate-500 text-green-700"><?php echo e($payment->amountpaid); ?></td>
                            </tr>

                            <tr class="py-2 px-4 text-sm">
                                <td class="border border-slate-500">Total Bill</td>
                                <td class="border border-slate-500 font-bold"><?php echo e($payment->payableamount); ?></td>
                            </tr>
                        </tbody>
                    </table>

                    <div class="flex justify-between">
                        <table class="w-3/6 my-4 text-left border-collapse border border-slate-500 text-sm font-semibold">
                            <tbody>
                                <tr class="py-2 px-4 text-sm">
                                    <td class="border border-slate-500 w-1/3">Bursar</td>
                                    <td class="border border-slate-500">Mrs Olasupo</td>
                                </tr>
                                <tr class="py-2 px-4 text-sm">
                                    <td class="border border-slate-500 w-1/3">Bursar Signature</td>
                                    <td class="border border-slate-500 h-24"></td>
                                </tr>
                            </tbody>
                        </table>

                        <div>
                            <small class="italic">created by tic atelier</small>
                        </div>
                    </div>
                </div>

            </div>
        </div>

    </body>
</html>
<?php /**PATH C:\Users\user\Desktop\Projects\student-portal\resources\views/bills/receipt.blade.php ENDPATH**/ ?>