
<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title>Upload Results</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

    <!-- Scripts -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
</head>

<body class="font-sans antialiased">
    <?php echo $__env->make('sweetalert::alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php

    ?>
    <style>
        input[type="radio"]:checked+span {
            display: block;
        }
    </style>

     <?php $__env->slot('header', null, []); ?> 
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            <?php echo e(__('View Students')); ?>

        </h2>
     <?php $__env->endSlot(); ?>

    <div class="container mx-auto">
        <div class="p-5 mx-auto my-10 bg-white rounded-md shadow-sm">
            <div class="flex justify-between px-10">
                <div class="flex w-full justify-start">
                    <a href="<?php echo e(route('admin-student')); ?>">
                        <button class="px-4 py-4 text-white bg-red-500 rounded-md  hover:bg-red-600 hover:outline-none">
                            <- Back </button>
                    </a>
                </div>

                <div class="flex w-full justify-end">
                    <a href="<?php echo e(route('admin-student-add')); ?>">
                        <button
                            class="px-4 py-4 text-white bg-green-500 rounded-md  hover:bg-green-600 hover:outline-none"
                            id="open-btn">
                            Add New Student
                        </button>
                    </a>

                </div>

            </div>


            
            <div class="w-full mt-12 py-2 px-4 text-xl">
                <div class="text-black text-center w-full my-2 py-2 px-4">
                    <h3 class="text-2xl font-extrabold"><?php echo e($students->first()->class); ?> Class List</h3>
                    <h4 class="text-xl font-semibold">Status: <?php echo e($status); ?></h4>

                    <div class="w-full flex justify-end py-8">
                        <input type="text" id="myInput"
                            class="block w-72 py-3 pl-4 pr-8 bg-white border border-gray-300 rounded-sm appearance-none cursor-pointer focus:outline-none hover:border-gray-400"
                            onkeyup="myFunction()" placeholder="Search for names..">
                    </div>

                    <table id="myTable" class="w-full text-left border-collapse border border-slate-500">
                        <thead>
                            <tr class="py-2 px-4 font-semibold">
                                <th class="border border-slate-500">S/N</th>
                                <th class="border border-slate-500">Full Name</th>
                                <th class="border border-slate-500">Reg No</th>
                                <th class="border border-slate-500">Class</th>
                                <th class="border border-slate-500">Department</th>
                                <th class="border border-slate-500">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                                $i = 0;
                            ?>
                            <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="py-2 px-4">
                                    <td class="border border-slate-500"><?php echo e($i = $i + 1); ?></td>
                                    <td class="border border-slate-500">
                                        <?php echo e($item->surname); ?> <?php echo e($item->firstname); ?>

                                        <p class="text-sm text-end">

                                        </p>
                                    </td>
                                    <td class="border border-slate-500"><?php echo e($item->reg_no); ?>

                                        <?php if($item->status == 'active'): ?>
                                                <button
                                                    class="text-xs h-4 px-2 text-white bg-green-500 rounded-md  hover:bg-red-600 hover:outline-none">
                                                    Active
                                                </button>
                                            <?php elseif($item->status == 'inactive'): ?>
                                                <button
                                                    class="text-xs h-4 px-2 text-white bg-red-500 rounded-md  hover:bg-red-600 hover:outline-none">
                                                    Inactive
                                                </button>
                                            <?php else: ?>
                                                <button
                                                    class="text-xs h-4 px-2 text-white bg-green-500 rounded-md  hover:bg-red-600 hover:outline-none">
                                                    Graduated
                                                </button>
                                            <?php endif; ?>
                                    </td>
                                    <td class="border border-slate-500"><?php echo e($item->class); ?></td>
                                    <td class="border border-slate-500"><?php echo e($item->dept); ?></td>

                                    <td class="border border-slate-500 w-32">
                                        <div class="flex gap-2 py-2 px-4">
                                            <div class="">
                                                <form action="<?php echo e(route('admin-student-edit')); ?>" method="GET">
                                                    <?php echo csrf_field(); ?>
                                                    <input type="hidden" name="vim" value="<?php echo e($item->id); ?>">
                                                    <button details="Edit details and class"
                                                        class="text-xs h-8 px-4 text-white bg-blue-500 rounded-md  hover:bg-blue-600 hover:outline-none">
                                                        Edit
                                                    </button>
                                                </form>
                                            </div>
                                            <div class="">
                                                <form action="<?php echo e(route('admin-student-status')); ?>" method="POST">
                                                    <?php echo csrf_field(); ?>
                                                    <input type="hidden" name="vim" value="<?php echo e($item->id); ?>">
                                                    <button
                                                        class="text-xs h-8 px-4 text-white bg-orange-500 rounded-md  hover:bg-orange-600 hover:outline-none">
                                                        Change Status
                                                    </button>
                                                </form>
                                            </div>
                                            <div class="">
                                                <button
                                                    class="text-xs h-8 px-4 text-white bg-red-500 rounded-md  hover:bg-red-600 hover:outline-none">
                                                    Delete
                                                </button>
                                            </div>

                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                        
                    </table>


                </div>

            </div>
            
        </div>


    </div>

    <script>
        function myFunction() {
            // Declare variables
            var input, filter, table, tr, td, i, txtValue;
            input = document.getElementById("myInput");
            filter = input.value.toUpperCase();
            table = document.getElementById("myTable");
            tr = table.getElementsByTagName("tr");

            // Loop through all table rows, and hide those who don't match the search query
            for (i = 0; i < tr.length; i++) {
                td = tr[i].getElementsByTagName("td")[1];
                if (td) {
                    txtValue = td.textContent || td.innerText;
                    if (txtValue.toUpperCase().indexOf(filter) > -1) {
                        tr[i].style.display = "";
                    } else {
                        tr[i].style.display = "none";
                    }
                }
            }
        }
    </script>


    <script>
        let modal = document.getElementById('modal');
        let btn = document.getElementById('open-btn');
        let button = document.getElementById('ok-btn');

        btn.onclick = function() {
            modal.style.display = 'block';
        };

        button.onclick = function() {
            modal.style.display = 'none';
        };

        window.onclick = function(event) {
            if (event.target == modal) {
                modal.style.display = "none";
            }
        }
    </script>

</body>
</html>
<?php /**PATH C:\Users\Charles\Desktop\Builders Stone SMS\academic-portal\resources\views/admin/students/list.blade.php ENDPATH**/ ?>