<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <title><?php echo e($result->first()->reg_no); ?> <?php echo e($result->first()->term); ?> <?php echo e($result->first()->session); ?> Result</title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

        <!-- Scripts -->
        <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    </head>
    <body class="font-sans antialiased">
        <?php echo $__env->make('sweetalert::alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        
        <?php
            $surname = DB::table("students")->where("id", Auth::id())->first()->surname;
            $firstname = DB::table("students")->where("id", Auth::id())->first()->firstname;
            $reg_no = DB::table("students")->where("id", Auth::id())->first()->reg_no;

            //date in mm/dd/yyyy format; or it can be in other formats as well
            $birthDate = DB::table('students')
                        ->where('reg_no', $reg_no)->first()->DoB;
            //explode the date to get month, day and year
            if ($birthDate != null){
                $birthDate = explode("-", $birthDate);
                //get age from date or birthdate
                $age = (date("md", date("U", mktime(0, 0, 0, $birthDate[2], $birthDate[1], $birthDate[0]))) > date("md")
                                                    ? ((date("Y") - $birthDate[0]) - 1) : (date("Y") - $birthDate[0]));
            }
            else {
                $age = " ";
            }
        ?>

        <div class="flex justify-center">
            <div class="w-full mt-12 py-2 px-4 text-xl">
                <div class="flex my-4">
                    <div class="w-full flex justify-between">
                        <div>
                            <?php if (isset($component)) { $__componentOriginal8892e718f3d0d7a916180885c6f012e7 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.application-logo','data' => ['class' => 'w-30 h-20 fill-current text-gray-500']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('application-logo'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-30 h-20 fill-current text-gray-500']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8892e718f3d0d7a916180885c6f012e7)): ?>
<?php $component = $__componentOriginal8892e718f3d0d7a916180885c6f012e7; ?>
<?php unset($__componentOriginal8892e718f3d0d7a916180885c6f012e7); ?>
<?php endif; ?>
                        </div>
                        <div>
                            <h2 class="text-xl font-bold">
                                OAKFIELD SCHOOLS
                            </h2>
                            <h4 class="text-sm italic">Nursery, Primary and Secondary</h4>
                            <h4 class="text-sm ">ORIMERUNMU ROAD, ORIMERUNMU, OGUN STATE</h4>
                            <h4 class="text-sm italic">The Preferred....</h4>
                        </div>
                    </div>
                </div>
                <div class="text-black text-center w-full my-2 py-2 px-4">
                    <h3 class="text-xl font-extrabold"><?php echo e($result->first()->session); ?>, <?php echo e($result->first()->term); ?> Mid-Term Report Sheet</h3>
                    <table class="w-full text-left border-collapse border border-slate-500 text-sm">
                        <thead>
                            <tr class="py-2 px-4 font-semibold">
                                <th class="border border-slate-500" colspan="2">Name: <?php echo e($surname); ?> <?php echo e($firstname); ?></th>
                                <th class="border border-slate-500" colspan="2">Reg_no: <?php echo e($reg_no); ?></th>
                            </tr>
                            <tr class="py-2 px-4 font-semibold">
                                <th class="border border-slate-500">Class: <?php echo e($result->first()->class); ?></th>
                                <th class="border border-slate-500">Age: <?php echo e($age); ?></th>
                                <th class="border border-slate-500">Term: <?php echo e($result->first()->term); ?></th>
                                <th class="border border-slate-500">Term: <?php echo e($result->first()->session); ?></th>
                            </tr>
                        </thead>
                    </table>

                    <table class="w-full my-4 text-left border-collapse border border-slate-500">
                        <thead>
                            <tr class="py-2 px-4 font-semibold text-sm">
                                <th class="border border-slate-500">Subjects</th>
                                <th class="border border-slate-500">Test (10)</th>
                                <th class="border border-slate-500">C.A (30)</th>
                                <th class="border border-slate-500">Total (40)</th>
                                <th class="border border-slate-500">Grade</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr class="py-2 px-4 text-sm">
                                <td class="border border-slate-500">English Language</td>
                                <td class="border border-slate-500"><?php echo e($eng_at); ?></td>
                                <td class="border border-slate-500"><?php echo e($eng_ex); ?></td>
                                <td class="border border-slate-500"><?php echo e($eng_ts); ?></td>
                                <td class="border border-slate-500">
                                    <?php if(($eng_ts > 29) && ($eng_ts <= 40)): ?>
                                        A
                                    <?php endif; ?>
                                    <?php if(($eng_ts > 24) && ($eng_ts < 30)): ?>
                                        B
                                    <?php endif; ?>
                                    <?php if(($eng_ts > 19) && ($eng_ts < 25)): ?>
                                        C
                                    <?php endif; ?>
                                    <?php if(($eng_ts >= 0) && ($eng_ts < 20)): ?>
                                        F
                                    <?php endif; ?>
                                </td>
                            </tr>

                            <tr class="py-2 px-4 text-sm">
                                <td class="border border-slate-500">Mathematics</td>
                                <td class="border border-slate-500"><?php echo e($mat->at); ?></td>
                                <td class="border border-slate-500"><?php echo e($mat->ex); ?></td>
                                <td class="border border-slate-500"><?php echo e($mat->ts); ?></td>
                                <td class="border border-slate-500">
                                    <?php if(($mat->ts > 29) && ($mat->ts <= 40)): ?>
                                        A
                                    <?php endif; ?>
                                    <?php if(($mat->ts > 24) && ($mat->ts < 30)): ?>
                                        B
                                    <?php endif; ?>
                                    <?php if(($mat->ts > 19) && ($mat->ts < 25)): ?>
                                        C
                                    <?php endif; ?>
                                    <?php if(($mat->ts >= 0) && ($mat->ts < 20)): ?>
                                        F
                                    <?php endif; ?>
                                </td>
                            </tr>


                            <tr class="py-2 px-4 text-sm">
                                <td class="border border-slate-500">Basic Science and Technology</td>
                                <td class="border border-slate-500"><?php echo e($bst_at); ?></td>
                                <td class="border border-slate-500"><?php echo e($bst_ex); ?></td>
                                <td class="border border-slate-500"><?php echo e($bst_ts); ?></td>
                                <td class="border border-slate-500">
                                    <?php if(($bst_ts > 29) && ($bst_ts <= 40)): ?>
                                        A
                                    <?php endif; ?>
                                    <?php if(($bst_ts > 24) && ($bst_ts < 30)): ?>
                                        B
                                    <?php endif; ?>
                                    <?php if(($bst_ts > 19) && ($bst_ts < 25)): ?>
                                        C
                                    <?php endif; ?>
                                    <?php if(($bst_ts >= 0) && ($bst_ts < 20)): ?>
                                        F
                                    <?php endif; ?>
                                </td>
                            </tr>

                            <tr class="py-2 px-4 text-sm">
                                <td class="border border-slate-500">Creative and Cultural Art</td>
                                <td class="border border-slate-500"><?php echo e($cc_at); ?></td>
                                <td class="border border-slate-500"><?php echo e($cc_ex); ?></td>
                                <td class="border border-slate-500"><?php echo e($cc_ts); ?></td>
                                <td class="border border-slate-500">
                                    <?php if(($cc_ts > 29) && ($cc_ts <= 40)): ?>
                                        A
                                    <?php endif; ?>
                                    <?php if(($cc_ts > 24) && ($cc_ts < 30)): ?>
                                        B
                                    <?php endif; ?>
                                    <?php if(($cc_ts > 19) && ($cc_ts < 25)): ?>
                                        C
                                    <?php endif; ?>
                                    <?php if(($cc_ts >= 0) && ($cc_ts < 20)): ?>
                                        F
                                    <?php endif; ?>
                                </td>
                            </tr>

                            <tr class="py-2 px-4 text-sm">
                                <td class="border border-slate-500">National Values Education</td>
                                <td class="border border-slate-500"><?php echo e($nve_at); ?></td>
                                <td class="border border-slate-500"><?php echo e($nve_ex); ?></td>
                                <td class="border border-slate-500"><?php echo e($nve_ts); ?></td>
                                <td class="border border-slate-500">
                                    <?php if(($nve_ts > 29) && ($nve_ts <= 40)): ?>
                                        A
                                    <?php endif; ?>
                                    <?php if(($nve_ts > 24) && ($nve_ts < 30)): ?>
                                        B
                                    <?php endif; ?>
                                    <?php if(($nve_ts > 19) && ($nve_ts < 25)): ?>
                                        C
                                    <?php endif; ?>
                                    <?php if(($nve_ts >= 0) && ($nve_ts < 20)): ?>
                                        F
                                    <?php endif; ?>
                                </td>
                            </tr>

                            <tr class="py-2 px-4 text-sm">
                                <td class="border border-slate-500">Pro-Vocational Studies</td>
                                <td class="border border-slate-500"><?php echo e($pvs_at); ?></td>
                                <td class="border border-slate-500"><?php echo e($pvs_ex); ?></td>
                                <td class="border border-slate-500"><?php echo e($pvs_ts); ?></td>
                                <td class="border border-slate-500">
                                    <?php if(($pvs_ts > 29) && ($pvs_ts <= 40)): ?>
                                        A
                                    <?php endif; ?>
                                    <?php if(($pvs_ts > 24) && ($pvs_ts < 30)): ?>
                                        B
                                    <?php endif; ?>
                                    <?php if(($pvs_ts > 19) && ($pvs_ts < 25)): ?>
                                        C
                                    <?php endif; ?>
                                    <?php if(($pvs_ts >= 0) && ($pvs_ts < 20)): ?>
                                        F
                                    <?php endif; ?>
                                </td>
                            </tr>

                            <tr class="py-2 px-4 text-sm">
                                <td class="border border-slate-500">French</td>
                                <td class="border border-slate-500"><?php echo e($fr->at); ?></td>
                                <td class="border border-slate-500"><?php echo e($fr->ex); ?></td>
                                <td class="border border-slate-500"><?php echo e($fr->ts); ?></td>
                                <td class="border border-slate-500">
                                    <?php if(($fr->ts > 29) && ($fr->ts <= 40)): ?>
                                        A
                                    <?php endif; ?>
                                    <?php if(($fr->ts > 24) && ($fr->ts < 30)): ?>
                                        B
                                    <?php endif; ?>
                                    <?php if(($fr->ts > 19) && ($fr->ts < 25)): ?>
                                        C
                                    <?php endif; ?>
                                    <?php if(($fr->ts >= 0) && ($fr->ts < 20)): ?>
                                        F
                                    <?php endif; ?>
                                </td>
                            </tr>

                            <tr class="py-2 px-4 text-sm">
                                <td class="border border-slate-500">Yoruba</td>
                                <td class="border border-slate-500"><?php echo e($yo->at); ?></td>
                                <td class="border border-slate-500"><?php echo e($yo->ex); ?></td>
                                <td class="border border-slate-500"><?php echo e($yo->ts); ?></td>
                                <td class="border border-slate-500">
                                    <?php if(($yo->ts > 29) && ($yo->ts <= 40)): ?>
                                        A
                                    <?php endif; ?>
                                    <?php if(($yo->ts > 24) && ($yo->ts < 30)): ?>
                                        B
                                    <?php endif; ?>
                                    <?php if(($yo->ts > 19) && ($yo->ts < 25)): ?>
                                        C
                                    <?php endif; ?>
                                    <?php if(($yo->ts >= 0) && ($yo->ts < 20)): ?>
                                        F
                                    <?php endif; ?>
                                </td>
                            </tr>

                            <tr class="py-2 px-4 text-sm">
                                <td class="border border-slate-500">Business Studies</td>
                                <td class="border border-slate-500"><?php echo e($bus->at); ?></td>
                                <td class="border border-slate-500"><?php echo e($bus->ex); ?></td>
                                <td class="border border-slate-500"><?php echo e($bus->ts); ?></td>
                                <td class="border border-slate-500">
                                    <?php if(($bus->ts > 29) && ($bus->ts <= 40)): ?>
                                        A
                                    <?php endif; ?>
                                    <?php if(($bus->ts > 24) && ($bus->ts < 30)): ?>
                                        B
                                    <?php endif; ?>
                                    <?php if(($bus->ts > 19) && ($bus->ts < 25)): ?>
                                        C
                                    <?php endif; ?>
                                    <?php if(($bus->ts >= 0) && ($bus->ts < 20)): ?>
                                        F
                                    <?php endif; ?>
                                </td>
                            </tr>

                            <tr class="py-2 px-4 text-sm">
                                <td class="border border-slate-500">Christian Religious Studies</td>
                                <td class="border border-slate-500"><?php echo e($crs->at); ?></td>
                                <td class="border border-slate-500"><?php echo e($crs->ex); ?></td>
                                <td class="border border-slate-500"><?php echo e($crs->ts); ?></td>
                                <td class="border border-slate-500">
                                    <?php if(($crs->ts > 29) && ($crs->ts <= 40)): ?>
                                        A
                                    <?php endif; ?>
                                    <?php if(($crs->ts > 24) && ($crs->ts < 30)): ?>
                                        B
                                    <?php endif; ?>
                                    <?php if(($crs->ts > 19) && ($crs->ts < 25)): ?>
                                        C
                                    <?php endif; ?>
                                    <?php if(($crs->ts >= 0) && ($crs->ts < 20)): ?>
                                        F
                                    <?php endif; ?>
                                </td>
                            </tr>

                            <tr class="py-2 px-4 text-sm">
                                <td class="border border-slate-500">Diction</td>
                                <td class="border border-slate-500"><?php echo e($dic->at); ?></td>
                                <td class="border border-slate-500"><?php echo e($dic->ex); ?></td>
                                <td class="border border-slate-500"><?php echo e($dic->ts); ?></td>
                                <td class="border border-slate-500">
                                    <?php if(($dic->ts > 29) && ($dic->ts <= 40)): ?>
                                        A
                                    <?php endif; ?>
                                    <?php if(($dic->ts > 24) && ($dic->ts < 30)): ?>
                                        B
                                    <?php endif; ?>
                                    <?php if(($dic->ts > 19) && ($dic->ts < 25)): ?>
                                        C
                                    <?php endif; ?>
                                    <?php if(($dic->ts >= 0) && ($dic->ts < 20)): ?>
                                        F
                                    <?php endif; ?>
                                </td>
                            </tr>

                            <tr class="py-2 px-4 text-sm">
                                <td class="border border-slate-500">History</td>
                                <td class="border border-slate-500"><?php echo e($his->at); ?></td>
                                <td class="border border-slate-500"><?php echo e($his->ex); ?></td>
                                <td class="border border-slate-500"><?php echo e($his->ts); ?></td>
                                <td class="border border-slate-500">
                                    <?php if(($his->ts > 29) && ($his->ts <= 40)): ?>
                                        A
                                    <?php endif; ?>
                                    <?php if(($his->ts > 24) && ($his->ts < 30)): ?>
                                        B
                                    <?php endif; ?>
                                    <?php if(($his->ts > 19) && ($his->ts < 25)): ?>
                                        C
                                    <?php endif; ?>
                                    <?php if(($his->ts >= 0) && ($his->ts < 20)): ?>
                                        F
                                    <?php endif; ?>
                                </td>
                            </tr>

                        </tbody>
                    </table>

                    <div class="flex justify-between">
                        <table class="w-3/6 my-4 text-left border-collapse border border-slate-500 text-sm font-semibold">
                            <tbody>
                                <tr class="py-2 px-4 text-sm">
                                    <td class="border border-slate-500 w-1/3">Total Mark</td>
                                    <td class="border border-slate-500"><?php echo e($total); ?></td>
                                </tr>
                                <tr class="py-2 px-4 text-sm">
                                    <td class="border border-slate-500 w-1/3">Achievable Mark</td>
                                    <td class="border border-slate-500"><?php echo e($total_achievable); ?></td>
                                </tr>
                                <tr class="py-2 px-4 text-sm">
                                    <td class="border border-slate-500 w-1/3">Percentage</td>
                                    <td class="border border-slate-500"><?php echo e($percentage); ?>%</td>
                                </tr>
                                <tr class="py-2 px-4 text-sm">
                                    <td class="border border-slate-500 w-1/3">Remarks</td>
                                    <td class="border border-slate-500">
                                        <?php if(($percentage > 74) && ($percentage < 101)): ?>
                                            A
                                        <?php endif; ?>
                                        <?php if(($percentage > 59) && ($percentage < 75)): ?>
                                            B
                                        <?php endif; ?>
                                        <?php if(($percentage > 49) && ($percentage < 60)): ?>
                                            C
                                        <?php endif; ?>
                                        <?php if(($percentage >= 0) && ($percentage < 50)): ?>
                                            F
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <tr class="py-2 px-4 text-sm">
                                    <td class="border border-slate-500 w-1/3">Teacher's Comments</td>
                                    <td class="border border-slate-500 h-24"></td>
                                </tr>
                                <tr class="py-2 px-4 text-sm">
                                    <td class="border border-slate-500 w-1/3">Principal/Head Teacher's Comments</td>
                                    <td class="border border-slate-500 h-24"></td>
                                </tr>
                            </tbody>
                        </table>

                        <table class="w-2/6 my-4 text-center border-collapse border border-slate-500 text-sm">
                            <thead>
                                <tr class="py-2 px-4 font-semibold text-sm">
                                    <th class="border border-slate-500" colspan="2">Grading System</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr class="py-2 px-4 text-sm font-semibold">
                                    <td class="border border-slate-500 w-1/2">A</td>
                                    <td class="border border-slate-500 w-1/2">30 - 40</td>
                                </tr>
                                <tr class="py-2 px-4 text-sm font-semibold">
                                    <td class="border border-slate-500 w-1/2">B</td>
                                    <td class="border border-slate-500 w-1/2">25 - 29</td>
                                </tr>
                                <tr class="py-2 px-4 text-sm font-semibold">
                                    <td class="border border-slate-500 w-1/2">C</td>
                                    <td class="border border-slate-500 w-1/2">20 - 24</td>
                                </tr>
                                <tr class="py-2 px-4 text-sm font-semibold">
                                    <td class="border border-slate-500 w-1/2">F</td>
                                    <td class="border border-slate-500 w-1/2">0 - 19</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

            </div>
        </div>

    </body>
</html>
<?php /**PATH C:\Users\user\Desktop\Projects\student-portal\resources\views/result-checker/jss/midterm.blade.php ENDPATH**/ ?>