<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <title><?php echo e($result->first()->reg_no); ?> <?php echo e($result->first()->term); ?> <?php echo e($result->first()->session); ?> Result</title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

        <!-- Scripts -->
        <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    </head>
    <script type="text/javascript">
        window.addEventListener("load", window.print());
   </script>
    <body class="font-sans antialiased">
        <?php echo $__env->make('sweetalert::alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        
        <?php
            $surname = DB::table("students")->where("id", Auth::id())->first()->surname;
            $firstname = DB::table("students")->where("id", Auth::id())->first()->firstname;
            $reg_no = DB::table("students")->where("id", Auth::id())->first()->reg_no;

            //date in mm/dd/yyyy format; or it can be in other formats as well
            $birthDate = DB::table('students')
                        ->where('reg_no', $reg_no)->first()->DoB;
            //explode the date to get month, day and year
            if ($birthDate != null){
                $birthDate = explode("-", $birthDate);
                //get age from date or birthdate
                $age = (date("md", date("U", mktime(0, 0, 0, $birthDate[2], $birthDate[1], $birthDate[0]))) > date("md")
                                                    ? ((date("Y") - $birthDate[0]) - 1) : (date("Y") - $birthDate[0]));
            }
            else {
                $age = " ";
            }
        ?>

        <div class="flex justify-center">
            <div class="w-full mt-12 py-2 px-4 text-xl">
                <div class="flex my-4">
                    <div class="w-full flex justify-between">
                        <div>
                            <?php if (isset($component)) { $__componentOriginal8892e718f3d0d7a916180885c6f012e7 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.application-logo','data' => ['class' => 'w-30 h-20 fill-current text-gray-500']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('application-logo'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-30 h-20 fill-current text-gray-500']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8892e718f3d0d7a916180885c6f012e7)): ?>
<?php $component = $__componentOriginal8892e718f3d0d7a916180885c6f012e7; ?>
<?php unset($__componentOriginal8892e718f3d0d7a916180885c6f012e7); ?>
<?php endif; ?>
                        </div>
                        <div>
                            <h2 class="text-xl font-bold">
                                OAKFIELD SCHOOLS
                            </h2>
                            <h4 class="text-sm italic">Nursery, Primary and Secondary</h4>
                            <h4 class="text-sm ">ORIMERUNMU ROAD, ORIMERUNMU, OGUN STATE</h4>
                            <h4 class="text-sm italic">The Preferred....</h4>
                        </div>
                    </div>
                </div>
                <div class="text-black text-center w-full my-2 py-2 px-4">
                    <h3 class="text-xl font-extrabold"><?php echo e($result->first()->session); ?>, <?php echo e($result->first()->term); ?> Term Report Sheet</h3>
                    <table class="w-full text-left border-collapse border border-slate-500 text-sm">
                        <thead>
                            <tr class="py-2 px-4 font-semibold">
                                <th class="border border-slate-500" colspan="2">Name: <?php echo e($surname); ?> <?php echo e($firstname); ?></th>
                                <th class="border border-slate-500" colspan="2">Reg_no: <?php echo e($reg_no); ?></th>
                            </tr>
                            <tr class="py-2 px-4 font-semibold">
                                <th class="border border-slate-500">Class: <?php echo e($result->first()->class); ?></th>
                                <th class="border border-slate-500">Age: <?php echo e($age); ?></th>
                                <th class="border border-slate-500">Term: <?php echo e($result->first()->term); ?></th>
                                <th class="border border-slate-500">Session: <?php echo e($result->first()->session); ?></th>
                            </tr>
                        </thead>
                    </table>

                    <table class="w-full my-4 text-left border-collapse border border-slate-500">
                        <thead>
                            <tr class="py-2 px-4 font-semibold text-sm">
                                <th class="border border-slate-500">Subjects</th>
                                <th class="border border-slate-500">Midterm (10)</th>
                                <th class="border border-slate-500">C.A (20)</th>
                                <th class="border border-slate-500">C.A (70)</th>
                                <th class="border border-slate-500">Total (100)</th>
                                <th class="border border-slate-500">Grade</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr class="py-2 px-4 text-sm">
                                <td class="border border-slate-500">English Language</td>
                                <td class="border border-slate-500"><?php echo e($eng_mt); ?></td>
                                <td class="border border-slate-500"><?php echo e($eng_ca); ?></td>
                                <td class="border border-slate-500"><?php echo e($eng_ex); ?></td>
                                <td class="border border-slate-500"><?php echo e($eng_ts); ?></td>
                                <td class="border border-slate-500">
                                    <?php if(($eng_ts > 74) && ($eng_ts <= 100)): ?>
                                        A
                                    <?php endif; ?>
                                    <?php if(($eng_ts > 59) && ($eng_ts < 75)): ?>
                                        B
                                    <?php endif; ?>
                                    <?php if(($eng_ts > 49) && ($eng_ts < 60)): ?>
                                        C
                                    <?php endif; ?>
                                    <?php if(($eng_ts >= 0) && ($eng_ts < 50)): ?>
                                        F
                                    <?php endif; ?>
                                </td>
                            </tr>

                            <tr class="py-2 px-4 text-sm">
                                <td class="border border-slate-500">Mathematics</td>
                                <td class="border border-slate-500"><?php echo e($mat->mt); ?></td>
                                <td class="border border-slate-500"><?php echo e($mat->ca); ?></td>
                                <td class="border border-slate-500"><?php echo e($mat->ex); ?></td>
                                <td class="border border-slate-500"><?php echo e($mat->ts); ?></td>
                                <td class="border border-slate-500">
                                    <?php if(($mat->ts > 74) && ($mat->ts <= 100)): ?>
                                        A
                                    <?php endif; ?>
                                    <?php if(($mat->ts > 59) && ($mat->ts < 75)): ?>
                                        B
                                    <?php endif; ?>
                                    <?php if(($mat->ts > 49) && ($mat->ts < 60)): ?>
                                        C
                                    <?php endif; ?>
                                    <?php if(($mat->ts >= 0) && ($mat->ts < 50)): ?>
                                        F
                                    <?php endif; ?>
                                </td>
                            </tr>


                            <tr class="py-2 px-4 text-sm">
                                <td class="border border-slate-500">Basic Science and Technology</td>
                                <td class="border border-slate-500"><?php echo e($bst_mt); ?></td>
                                <td class="border border-slate-500"><?php echo e($bst_ca); ?></td>
                                <td class="border border-slate-500"><?php echo e($bst_ex); ?></td>
                                <td class="border border-slate-500"><?php echo e($bst_ts); ?></td>
                                <td class="border border-slate-500">
                                    <?php if(($bst_ts > 74) && ($bst_ts <= 100)): ?>
                                        A
                                    <?php endif; ?>
                                    <?php if(($bst_ts > 59) && ($bst_ts < 75)): ?>
                                        B
                                    <?php endif; ?>
                                    <?php if(($bst_ts > 49) && ($bst_ts < 60)): ?>
                                        C
                                    <?php endif; ?>
                                    <?php if(($bst_ts >= 0) && ($bst_ts < 50)): ?>
                                        F
                                    <?php endif; ?>
                                </td>
                            </tr>

                            <tr class="py-2 px-4 text-sm">
                                <td class="border border-slate-500">Creative and Cultural Art</td>
                                <td class="border border-slate-500"><?php echo e($cc_mt); ?></td>
                                <td class="border border-slate-500"><?php echo e($cc_ca); ?></td>
                                <td class="border border-slate-500"><?php echo e($cc_ex); ?></td>
                                <td class="border border-slate-500"><?php echo e($cc_ts); ?></td>
                                <td class="border border-slate-500">
                                    <?php if(($cc_ts > 74) && ($cc_ts <= 100)): ?>
                                        A
                                    <?php endif; ?>
                                    <?php if(($cc_ts > 59) && ($cc_ts < 75)): ?>
                                        B
                                    <?php endif; ?>
                                    <?php if(($cc_ts > 49) && ($cc_ts < 60)): ?>
                                        C
                                    <?php endif; ?>
                                    <?php if(($cc_ts >= 0) && ($cc_ts < 50)): ?>
                                        F
                                    <?php endif; ?>
                                </td>
                            </tr>

                            <tr class="py-2 px-4 text-sm">
                                <td class="border border-slate-500">National Values Education</td>
                                <td class="border border-slate-500"><?php echo e($nve_mt); ?></td>
                                <td class="border border-slate-500"><?php echo e($nve_ca); ?></td>
                                <td class="border border-slate-500"><?php echo e($nve_ex); ?></td>
                                <td class="border border-slate-500"><?php echo e($nve_ts); ?></td>
                                <td class="border border-slate-500">
                                    <?php if(($nve_ts > 74) && ($nve_ts <= 100)): ?>
                                        A
                                    <?php endif; ?>
                                    <?php if(($nve_ts > 59) && ($nve_ts < 75)): ?>
                                        B
                                    <?php endif; ?>
                                    <?php if(($nve_ts > 49) && ($nve_ts < 60)): ?>
                                        C
                                    <?php endif; ?>
                                    <?php if(($nve_ts >= 0) && ($nve_ts < 50)): ?>
                                        F
                                    <?php endif; ?>
                                </td>
                            </tr>

                            <tr class="py-2 px-4 text-sm">
                                <td class="border border-slate-500">Pro-Vocational Studies</td>
                                <td class="border border-slate-500"><?php echo e($pvs_mt); ?></td>
                                <td class="border border-slate-500"><?php echo e($pvs_ca); ?></td>
                                <td class="border border-slate-500"><?php echo e($pvs_ex); ?></td>
                                <td class="border border-slate-500"><?php echo e($pvs_ts); ?></td>
                                <td class="border border-slate-500">
                                    <?php if(($pvs_ts > 74) && ($pvs_ts <= 100)): ?>
                                        A
                                    <?php endif; ?>
                                    <?php if(($pvs_ts > 59) && ($pvs_ts < 75)): ?>
                                        B
                                    <?php endif; ?>
                                    <?php if(($pvs_ts > 49) && ($pvs_ts < 60)): ?>
                                        C
                                    <?php endif; ?>
                                    <?php if(($pvs_ts >= 0) && ($pvs_ts < 50)): ?>
                                        F
                                    <?php endif; ?>
                                </td>
                            </tr>

                            <tr class="py-2 px-4 text-sm">
                                <td class="border border-slate-500">French</td>
                                <td class="border border-slate-500"><?php echo e($fr->mt); ?></td>
                                <td class="border border-slate-500"><?php echo e($fr->ca); ?></td>
                                <td class="border border-slate-500"><?php echo e($fr->ex); ?></td>
                                <td class="border border-slate-500"><?php echo e($fr->ts); ?></td>
                                <td class="border border-slate-500">
                                    <?php if(($fr->ts > 74) && ($fr->ts <= 100)): ?>
                                        A
                                    <?php endif; ?>
                                    <?php if(($fr->ts > 59) && ($fr->ts < 75)): ?>
                                        B
                                    <?php endif; ?>
                                    <?php if(($fr->ts > 49) && ($fr->ts < 60)): ?>
                                        C
                                    <?php endif; ?>
                                    <?php if(($fr->ts >= 0) && ($fr->ts < 50)): ?>
                                        F
                                    <?php endif; ?>
                                </td>
                            </tr>

                            <tr class="py-2 px-4 text-sm">
                                <td class="border border-slate-500">Yoruba</td>
                                <td class="border border-slate-500"><?php echo e($yo->mt); ?></td>
                                <td class="border border-slate-500"><?php echo e($yo->ca); ?></td>
                                <td class="border border-slate-500"><?php echo e($yo->ex); ?></td>
                                <td class="border border-slate-500"><?php echo e($yo->ts); ?></td>
                                <td class="border border-slate-500">
                                    <?php if(($yo->ts > 74) && ($yo->ts <= 100)): ?>
                                        A
                                    <?php endif; ?>
                                    <?php if(($yo->ts > 59) && ($yo->ts < 75)): ?>
                                        B
                                    <?php endif; ?>
                                    <?php if(($yo->ts > 49) && ($yo->ts < 60)): ?>
                                        C
                                    <?php endif; ?>
                                    <?php if(($yo->ts >= 0) && ($yo->ts < 50)): ?>
                                        F
                                    <?php endif; ?>
                                </td>
                            </tr>

                            <tr class="py-2 px-4 text-sm">
                                <td class="border border-slate-500">Business Studies</td>
                                <td class="border border-slate-500"><?php echo e($bus->mt); ?></td>
                                <td class="border border-slate-500"><?php echo e($bus->ca); ?></td>
                                <td class="border border-slate-500"><?php echo e($bus->ex); ?></td>
                                <td class="border border-slate-500"><?php echo e($bus->ts); ?></td>
                                <td class="border border-slate-500">
                                    <?php if(($bus->ts > 74) && ($bus->ts <= 100)): ?>
                                        A
                                    <?php endif; ?>
                                    <?php if(($bus->ts > 59) && ($bus->ts < 75)): ?>
                                        B
                                    <?php endif; ?>
                                    <?php if(($bus->ts > 49) && ($bus->ts < 60)): ?>
                                        C
                                    <?php endif; ?>
                                    <?php if(($bus->ts >= 0) && ($bus->ts < 50)): ?>
                                        F
                                    <?php endif; ?>
                                </td>
                            </tr>

                            <tr class="py-2 px-4 text-sm">
                                <td class="border border-slate-500">Christian Religious Studies</td>
                                <td class="border border-slate-500"><?php echo e($crs->mt); ?></td>
                                <td class="border border-slate-500"><?php echo e($crs->ca); ?></td>
                                <td class="border border-slate-500"><?php echo e($crs->ex); ?></td>
                                <td class="border border-slate-500"><?php echo e($crs->ts); ?></td>
                                <td class="border border-slate-500">
                                    <?php if(($crs->ts > 74) && ($crs->ts <= 100)): ?>
                                        A
                                    <?php endif; ?>
                                    <?php if(($crs->ts > 59) && ($crs->ts < 75)): ?>
                                        B
                                    <?php endif; ?>
                                    <?php if(($crs->ts > 49) && ($crs->ts < 60)): ?>
                                        C
                                    <?php endif; ?>
                                    <?php if(($crs->ts >= 0) && ($crs->ts < 50)): ?>
                                        F
                                    <?php endif; ?>
                                </td>
                            </tr>

                            <tr class="py-2 px-4 text-sm">
                                <td class="border border-slate-500">Diction</td>
                                <td class="border border-slate-500"><?php echo e($dic->mt); ?></td>
                                <td class="border border-slate-500"><?php echo e($dic->ca); ?></td>
                                <td class="border border-slate-500"><?php echo e($dic->ex); ?></td>
                                <td class="border border-slate-500"><?php echo e($dic->ts); ?></td>
                                <td class="border border-slate-500">
                                    <?php if(($dic->ts > 74) && ($dic->ts <= 100)): ?>
                                        A
                                    <?php endif; ?>
                                    <?php if(($dic->ts > 59) && ($dic->ts < 75)): ?>
                                        B
                                    <?php endif; ?>
                                    <?php if(($dic->ts > 49) && ($dic->ts < 60)): ?>
                                        C
                                    <?php endif; ?>
                                    <?php if(($dic->ts >= 0) && ($dic->ts < 50)): ?>
                                        F
                                    <?php endif; ?>
                                </td>
                            </tr>

                            <tr class="py-2 px-4 text-sm">
                                <td class="border border-slate-500">History</td>
                                <td class="border border-slate-500"><?php echo e($his->mt); ?></td>
                                <td class="border border-slate-500"><?php echo e($his->ca); ?></td>
                                <td class="border border-slate-500"><?php echo e($his->ex); ?></td>
                                <td class="border border-slate-500"><?php echo e($his->ts); ?></td>
                                <td class="border border-slate-500">
                                    <?php if(($his->ts > 74) && ($his->ts <= 100)): ?>
                                        A
                                    <?php endif; ?>
                                    <?php if(($his->ts > 59) && ($his->ts < 75)): ?>
                                        B
                                    <?php endif; ?>
                                    <?php if(($his->ts > 49) && ($his->ts < 60)): ?>
                                        C
                                    <?php endif; ?>
                                    <?php if(($his->ts >= 0) && ($his->ts < 50)): ?>
                                        F
                                    <?php endif; ?>
                                </td>
                            </tr>

                        </tbody>
                    </table>

                    <div class="flex justify-between">
                        <table class="w-3/6 my-4 text-left border-collapse border border-slate-500 text-sm font-semibold">
                            <tbody>
                                <tr class="py-2 px-4 text-sm">
                                    <td class="border border-slate-500 w-1/3">Total Mark</td>
                                    <td class="border border-slate-500"><?php echo e($total); ?></td>
                                </tr>
                                <tr class="py-2 px-4 text-sm">
                                    <td class="border border-slate-500 w-1/3">Achievable Mark</td>
                                    <td class="border border-slate-500"><?php echo e($total_achievable); ?></td>
                                </tr>
                                <tr class="py-2 px-4 text-sm">
                                    <td class="border border-slate-500 w-1/3">Percentage</td>
                                    <td class="border border-slate-500"><?php echo e($percentage); ?>%</td>
                                </tr>
                                <tr class="py-2 px-4 text-sm">
                                    <td class="border border-slate-500 w-1/3">Remarks</td>
                                    <td class="border border-slate-500">
                                        <?php if(($percentage > 74) && ($percentage < 101)): ?>
                                            A
                                        <?php endif; ?>
                                        <?php if(($percentage > 59) && ($percentage < 75)): ?>
                                            B
                                        <?php endif; ?>
                                        <?php if(($percentage > 49) && ($percentage < 60)): ?>
                                            C
                                        <?php endif; ?>
                                        <?php if(($percentage >= 0) && ($percentage < 50)): ?>
                                            F
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <tr class="py-2 px-4 text-sm">
                                    <td class="border border-slate-500 w-1/3">Teacher's Comments</td>
                                    <td class="border border-slate-500 h-24"></td>
                                </tr>
                                <tr class="py-2 px-4 text-sm">
                                    <td class="border border-slate-500 w-1/3">Principal's Comments</td>
                                    <td class="border border-slate-500 h-24"></td>
                                </tr>
                            </tbody>
                        </table>

                        <table class="w-2/6 my-4 text-center border-collapse border border-slate-500 text-sm">
                            <thead>
                                <tr class="py-2 px-4 font-semibold text-sm">
                                    <th class="border border-slate-500" colspan="2">Grading System</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr class="py-2 px-4 text-sm font-semibold">
                                    <td class="border border-slate-500 w-1/2">A</td>
                                    <td class="border border-slate-500 w-1/2">75 - 100</td>
                                </tr>
                                <tr class="py-2 px-4 text-sm font-semibold">
                                    <td class="border border-slate-500 w-1/2">B</td>
                                    <td class="border border-slate-500 w-1/2">60 - 74</td>
                                </tr>
                                <tr class="py-2 px-4 text-sm font-semibold">
                                    <td class="border border-slate-500 w-1/2">C</td>
                                    <td class="border border-slate-500 w-1/2">50 - 59</td>
                                </tr>
                                <tr class="py-2 px-4 text-sm font-semibold">
                                    <td class="border border-slate-500 w-1/2">F</td>
                                    <td class="border border-slate-500 w-1/2">0 - 49</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

            </div>
        </div>

    </body>
</html>
<?php /**PATH C:\Users\user\Desktop\Projects\student-portal\resources\views/result-checker/jss/result/result.blade.php ENDPATH**/ ?>