<?php

namespace Illuminate\Support\Facades;

interface Auth
{
    /**
     * @return \App\Models\Subject|false
     */
    public static function loginUsingId(mixed $id, bool $remember = false);

    /**
     * @return \App\Models\Subject|false
     */
    public static function onceUsingId(mixed $id);

    /**
     * @return \App\Models\Subject|null
     */
    public static function getUser();

    /**
     * @return \App\Models\Subject
     */
    public static function authenticate();

    /**
     * @return \App\Models\Subject|null
     */
    public static function user();

    /**
     * @return \App\Models\Subject|null
     */
    public static function logoutOtherDevices(string $password);

    /**
     * @return \App\Models\Subject
     */
    public static function getLastAttempted();
}