<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Billoption;
use App\Models\BillPractical;
use App\Models\Bookoption;
use Alert;
use DB;

class BillController extends Controller
{
    public function index(){
        return view('bills.index');
    }

    public function select_bill_type(Request $request){
        $request->validate([
            'type' => ['required'],
        ]);

        if ($request->type == "schoolfees"){
            $term = DB::table('billoptions')->latest()->first()->term;
            $session = DB::table('billoptions')->latest()->first()->session;
            $all = DB::table('billoptions')->where('term', $term)->where('session', $session)->get();
            return view('bills.schoolfees.index', ['all' => $all]);
        }
        elseif($request->type == "listofbooks"){
            Alert::success('Pending', 'Feature coming soon');
            return redirect('bills');
            // return view('bills.listofbooks.index');
        }
        elseif($request->type == "practicals"){
            $all = DB::table('bill_practicals')->get();
            return view('bills.practicals.index', ['all' => $all]);
        }
        else{
            Alert::error('Invalid Option', 'Select a valid option');
            return redirect()->back()->withErrors("Select a valid option")->withInput();
        }
    }

    // Practicals Functions
    public function practicals_create_update(Request $request){
        if($request->practical != null){
            $practical = $request->practical;
            $cost = $request->cost;

            $check = DB::table('bill_practicals')->where("practical", $practical)->first();
            if($check == null){
                BillPractical::create([
                    'practical' => $practical,
                    'cost' => $cost
                ]);
                Alert::success('Create Practical', 'Successfully');
            }
            if($check != null){
                BillPractical::where('practical', $practical)
                                ->update(['cost' => $cost]);
                Alert::success('Update Bill', 'Successfully');
            }

            return redirect('bills/type-of-bill?type=practicals');
        }
        Alert::error('Practical Required', 'Select a practical subject');
        return redirect()->back();
    }

    // School fees Functions
    public function schoolfees_create(Request $request){
        $classes = array('KG 1', 'KG 2', 'NURSERY 1', 'NURSERY 2', 'PRIMARY 1', 'PRIMARY 2', 'PRIMARY 3', 'PRIMARY 4', 'PRIMARY 5', 'PRIMARY 6', 'JSS 1', 'JSS 2', 'JSS 3', 'SSS 1', 'SSS 2', 'SSS 3');

        // Avoid duplicated bills
        $check = Billoption::where('term', $request->term)->where('session', $request->session)->get();
        if($check->first() != null){
            Alert::error('Duplicate Bill', 'Bill created already');
            return redirect()->back();
        }

        // Create new bill
        foreach ($classes as $class){
            $bill = Billoption::create([
                'class' => $class,
                'term' => $request->term,
                'session' => $request->session,
            ]);
        }

        //Check if first term bill has been created so as to repeat bill
        $check = Billoption::where('session', $request->session)->where('term', 'First')->get();
        if ($check->first() != null && $request->term == "Second" || $request->term == "Third"){
            foreach($check as $bill){
                Billoption::where('term', $request->term)
                    ->where('session', $request->session)
                    ->where('class', $bill->class)
                    ->update([
                        'tuition' => $bill->tuition,
                        'others' => $bill->others,
                        'pta' => $bill->pta,
                        'entryfee' => $bill->entryfee,
                        'lessonfee' => $bill->lessonfee,
                        'valedictoryfee' => $bill->valedictory,
                    ]);
            }
        }
        Alert::success('Create Bill', 'Successfully');
        return redirect()->back();
    }

    public function schoolfees_update(Request $request){
        $id = $request->id;
        $bill = Billoption::find($id);

        return view('bills.schoolfees.update', ['bill' => $bill]);
    }

    public function schoolfees_update_single(Request $request){
        Billoption::where('id', $request->id)
                    ->update([
                        'tuition' => $request->tution,
                        'others' => $request->others,
                        'pta' => $request->pta,
                        'entryfee' => $request->entryfee,
                        'lessonfee' => $request->lessonfee,
                        'valedictoryfee' => $request->valedictory,
                    ]);

        Alert::success('Update Bill', 'Successfully');
        return redirect('bills/type-of-bill?type=schoolfees');
    }

    public function schoolfees_query(Request $request){
        if($request->term != null){
            $term = $request->term;
            $session = $request->session;
            $all = DB::table('billoptions')->where('term', $term)->where('session', $session)->get();
            if($all->first() != null){
                return view('bills.schoolfees.query', ['all' => $all]);
            }
            Alert::error('No Records', 'Records for the inputs not found');
            return redirect()->back();
        }
        Alert::error('Term Required', 'Select a term option');
        return redirect()->back();
    }
}
