<x-app-layout>


    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Bill Options/School Fees') }}
        </h2>
    </x-slot>

    <div class="container mx-auto">
        <div class="text-left">
            <div class="max-w-xl p-5 mx-auto my-10 bg-white rounded-md shadow-sm">
                <div class="text-center">
                  <h1 class="my-3 text-xl font-semibold text-gray-700">Create a Bill</h1>
                  <p class="text-gray-400">Fill up the form below to create a bill.</p>
                </div>
                <div>
                  <form class="mt-4" action="{{route('school-fees-update-single')}}" method="POST">
                    @csrf
                    <input type="text" name="id" value="{{ $bill->id }}" hidden>
                    <div class="flex gap-2">
                        <div class="mb-6 w-1/3">
                            <label for="name" class="block mb-2 text-sm text-gray-600"
                                >Class</label
                            >
                            <input
                                type="text"
                                name="class"
                                value="{{ $bill->class }}"
                                disabled
                                class="w-full px-3 py-2 placeholder-gray-300 border border-gray-300 rounded-md  focus:outline-none focus:ring focus:ring-green-100 focus:border-green-300"
                            />
                        </div>

                        <div class="mb-6 w-1/3">
                            <label for="name" class="block mb-2 text-sm text-gray-600"
                                >Term</label
                            >
                            <input
                                type="text"
                                name="term"
                                value="{{ $bill->term }}"
                                disabled
                                class="w-full px-3 py-2 placeholder-gray-300 border border-gray-300 rounded-md  focus:outline-none focus:ring focus:ring-green-100 focus:border-green-300"
                            />
                        </div>

                        <div class="mb-6 w-1/3">
                            <label for="name" class="block mb-2 text-sm text-gray-600"
                                >Session</label
                            >
                            <input
                                type="text"
                                name="session"
                                value="{{ $bill->session }}"
                                disabled
                                class="w-full px-3 py-2 placeholder-gray-300 border border-gray-300 rounded-md  focus:outline-none focus:ring focus:ring-green-100 focus:border-green-300"
                            />
                        </div>
                    </div>

                    <div class="flex gap-2 -mt-4">
                        <div class="mb-6 w-1/3">
                        <label for="name" class="block mb-2 text-sm text-gray-600"
                            >Tuition</label
                        >
                        <input
                            type="number"
                            name="tution"
                            value="{{ $bill->tuition }}"
                            required
                            class="w-full px-3 py-2 placeholder-gray-300 border border-gray-300 rounded-md  focus:outline-none focus:ring focus:ring-green-100 focus:border-green-300"
                        />
                        </div>

                        <div class="mb-6 w-1/3">
                            <label for="name" class="block mb-2 text-sm text-gray-600"
                            >Others</label
                            >
                            <input
                            type="number"
                            name="others"
                            value="{{ $bill->others }}"
                            required
                            class="w-full px-3 py-2 placeholder-gray-300 border border-gray-300 rounded-md  focus:outline-none focus:ring focus:ring-green-100 focus:border-green-300"
                            />
                        </div>

                        <div class="mb-6 w-1/3">
                            <label for="name" class="block mb-2 text-sm text-gray-600"
                            >PTA</label
                            >
                            <input
                            type="number"
                            name="pta"
                            value="{{ $bill->pta }}"
                            required
                            class="w-full px-3 py-2 placeholder-gray-300 border border-gray-300 rounded-md  focus:outline-none focus:ring focus:ring-green-100 focus:border-green-300"
                            />
                        </div>
                    </div>

                    <div class="flex gap-2">
                        <div class="mb-6 w-1/3">
                            <label for="name" class="block mb-2 text-sm text-gray-600"
                            >Entry Fee</label
                            >
                            <input
                            type="number"
                            name="entryfee"
                            value="{{ $bill->entryfee }}"
                            required
                            class="w-full px-3 py-2 placeholder-gray-300 border border-gray-300 rounded-md  focus:outline-none focus:ring focus:ring-green-100 focus:border-green-300"
                            />
                        </div>

                        <div class="mb-6 w-1/3">
                            <label for="name" class="block mb-2 text-sm text-gray-600"
                            >Lesson Fee </label
                            >
                            <input
                            type="number"
                            name="lessonfee"
                            value="{{ $bill->lessonfee }}"
                            class="w-full px-3 py-2 placeholder-gray-300 border border-gray-300 rounded-md  focus:outline-none focus:ring focus:ring-green-100 focus:border-green-300"
                            />
                            <span class="text-red-600 text-sm italic">*for examination classes</span>
                        </div>

                        <div class="mb-6 w-1/3">
                            <label for="name" class="block mb-2 text-sm text-gray-600"
                            >Valedictory/Prize Giving </label
                            >
                            <input
                            type="number"
                            name="valedictory"
                            value="{{ $bill->valedictoryfee }}"
                            class="w-full px-3 py-2 placeholder-gray-300 border border-gray-300 rounded-md  focus:outline-none focus:ring focus:ring-green-100 focus:border-green-300"
                            />
                            <span class="text-red-600 text-sm italic">*added by third term</span>
                        </div>
                    </div>


                    <div class="mb-6">
                      <button
                        type="submit"
                        class="w-full px-2 py-4 text-white bg-green-500 rounded-md  focus:bg-green-600 focus:outline-none"
                      >
                        Create Bills
                      </button>
                    </div>

                  </form>
                </div>
              </div>
        </div>
    </div>

</x-app-layout>


