<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Defaulters') }}
        </h2>
    </x-slot>

    <div class="container mx-auto">
        <div class="p-5 mx-auto my-10 bg-white rounded-md shadow-sm">
            <div class="flex justify-between px-10">
                <div class="text-left">
                    <h3 class="font-semibold text-2xl py-2 text-gray-800 leading-tight">{{ "View Student's Status" }}
                    </h3>
                </div>

                <div class="flex gap-2">
                    <div class="">
                        <a href="{{ route('defaulters') }}">
                            <button
                                class="px-4 py-4 text-white bg-blue-500 rounded-md  hover:bg-blue-700 focus:outline-none">
                                All
                            </button>
                        </a>
                    </div>
                    <div class="">
                        <a href="{{ route('cleared-students') }}">
                            <button
                                class="px-4 py-4 text-white bg-green-500 rounded-md  hover:bg-green-700 focus:outline-none">
                                Cleared
                            </button>
                        </a>
                    </div>
                    <div class="">
                        <a href="{{ route('defaulting-students') }}">
                            <button
                                class="px-4 py-4 text-white bg-yellow-500 rounded-md  hover:bg-yellow-700 focus:outline-none">
                                Defaulting
                            </button>
                        </a>
                    </div>
                </div>

            </div>

            {{-- Search table --}}
            <div class="w-full flex justify-end pt-8">
                <input type="text" id="myInput"
                    class="block w-72 py-3 pl-4 pr-8 bg-white border border-gray-300 rounded-sm appearance-none cursor-pointer focus:outline-none hover:border-gray-400"
                    onkeyup="myFunction()" placeholder="Search for names..">
            </div>


            {{-- defaulters list starts --}}
            <div class="w-full py-2 px-4 text-xl">
                <div class="text-black text-left w-full my-2 py-2 px-4">
                    <table id="myTable" class="w-full text-left border-collapse border border-slate-500">
                        <thead>
                            <tr class="py-2 px-4 font-semibold">
                                <th class="border border-slate-500 text-center">S/N</th>
                                <th class="border border-slate-500 text-center">Student's Name</th>
                                <th class="border border-slate-500 text-center">Student's Class</th>
                                <th class="border border-slate-500 text-center">Portal Access Number</th>
                                <th class="border border-slate-500 text-center">Status</th>
                                <th class="border border-slate-500"></th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $i = 0;
                            @endphp
                            @foreach ($statuses as $status)
                                <tr class="py-2 px-4">
                                    @php
                                        $student = \App\Models\Student::where('reg_no', $status->reg_no)->first();
                                    @endphp
                                    <td class="border border-slate-500">{{ $i += 1 }}</td>
                                    <td class="border border-slate-500">{{ $student->surname }}
                                        {{ $student->firstname }}</td>
                                    <td class="border border-slate-500">{{ $student->class }}</td>
                                    <td class="border border-slate-500">{{ $status->reg_no }}</td>
                                    <td class="border border-slate-500">
                                        <div class="flex justify-center py-2">
                                            @if ($status->status == 'cleared')
                                                <div class="py-2 px-4 rounded-xl bg-green-600 text-white text-xs">
                                                    {{ $status->status }}
                                                </div>
                                            @else
                                                <div class="py-2 px-4 rounded-xl bg-yellow-600 text-white text-xs">
                                                    {{ $status->status }}
                                                </div>
                                            @endif
                                        </div>
                                    </td>
                                    <td class="border border-slate-500">
                                        <form action="{{ route('change-defaulters-status') }}" method="post">
                                            @csrf
                                            <input type="text" name="id" value="{{ $status->id }}" hidden>
                                            <button type="submit"
                                                class="px-4 py-2 text-white text-sm bg-blue-500 rounded-md  hover:bg-blue-700 focus:outline-none">
                                                Change Status
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>


                </div>


            </div>
            {{-- defaulters list ends --}}
        </div>


    </div>

    <script>
        function myFunction() {
            // Declare variables
            var input, filter, table, tr, td, i, txtValue;
            input = document.getElementById("myInput");
            filter = input.value.toUpperCase();
            table = document.getElementById("myTable");
            tr = table.getElementsByTagName("tr");

            // Loop through all table rows, and hide those who don't match the search query
            for (i = 0; i < tr.length; i++) {
                td = tr[i].getElementsByTagName("td")[1];
                if (td) {
                    txtValue = td.textContent || td.innerText;
                    if (txtValue.toUpperCase().indexOf(filter) > -1) {
                        tr[i].style.display = "";
                    } else {
                        tr[i].style.display = "none";
                    }
                }
            }
        }
    </script>

</x-app-layout>
